/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.util.concurrent;

import java.util.concurrent.Callable;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import pro.gravit.repackage.io.netty.util.concurrent.AbstractScheduledEventExecutor;
import pro.gravit.repackage.io.netty.util.concurrent.EventExecutor;
import pro.gravit.repackage.io.netty.util.concurrent.PromiseTask;
import pro.gravit.repackage.io.netty.util.concurrent.ScheduledFuture;
import pro.gravit.repackage.io.netty.util.internal.DefaultPriorityQueue;
import pro.gravit.repackage.io.netty.util.internal.PriorityQueueNode;

final class ScheduledFutureTask<V>
extends PromiseTask<V>
implements ScheduledFuture<V>,
PriorityQueueNode {
    private long id;
    private long deadlineNanos;
    private final long periodNanos;
    private int queueIndex = -1;

    ScheduledFutureTask(AbstractScheduledEventExecutor abstractScheduledEventExecutor, Runnable runnable, long l) {
        super((EventExecutor)abstractScheduledEventExecutor, runnable);
        this.deadlineNanos = l;
        this.periodNanos = 0L;
    }

    ScheduledFutureTask(AbstractScheduledEventExecutor abstractScheduledEventExecutor, Runnable runnable, long l, long l2) {
        super((EventExecutor)abstractScheduledEventExecutor, runnable);
        this.deadlineNanos = l;
        this.periodNanos = ScheduledFutureTask.validatePeriod(l2);
    }

    ScheduledFutureTask(AbstractScheduledEventExecutor abstractScheduledEventExecutor, Callable<V> callable, long l, long l2) {
        super((EventExecutor)abstractScheduledEventExecutor, callable);
        this.deadlineNanos = l;
        this.periodNanos = ScheduledFutureTask.validatePeriod(l2);
    }

    ScheduledFutureTask(AbstractScheduledEventExecutor abstractScheduledEventExecutor, Callable<V> callable, long l) {
        super((EventExecutor)abstractScheduledEventExecutor, callable);
        this.deadlineNanos = l;
        this.periodNanos = 0L;
    }

    private static long validatePeriod(long l) {
        if (l == 0L) {
            throw new IllegalArgumentException("period: 0 (expected: != 0)");
        }
        return l;
    }

    ScheduledFutureTask<V> setId(long l) {
        if (this.id == 0L) {
            this.id = l;
        }
        return this;
    }

    @Override
    protected EventExecutor executor() {
        return super.executor();
    }

    public long deadlineNanos() {
        return this.deadlineNanos;
    }

    void setConsumed() {
        if (this.periodNanos == 0L) {
            assert (this.scheduledExecutor().getCurrentTimeNanos() >= this.deadlineNanos);
            this.deadlineNanos = 0L;
        }
    }

    public long delayNanos() {
        return this.delayNanos(this.scheduledExecutor().getCurrentTimeNanos());
    }

    static long deadlineToDelayNanos(long l, long l2) {
        return l2 == 0L ? 0L : Math.max(0L, l2 - l);
    }

    public long delayNanos(long l) {
        return ScheduledFutureTask.deadlineToDelayNanos(l, this.deadlineNanos);
    }

    @Override
    public long getDelay(TimeUnit timeUnit) {
        return timeUnit.convert(this.delayNanos(), TimeUnit.NANOSECONDS);
    }

    @Override
    public int compareTo(Delayed delayed) {
        if (this == delayed) {
            return 0;
        }
        ScheduledFutureTask scheduledFutureTask = (ScheduledFutureTask)delayed;
        long l = this.deadlineNanos() - scheduledFutureTask.deadlineNanos();
        if (l < 0L) {
            return -1;
        }
        if (l > 0L) {
            return 1;
        }
        if (this.id < scheduledFutureTask.id) {
            return -1;
        }
        assert (this.id != scheduledFutureTask.id);
        return 1;
    }

    @Override
    public void run() {
        assert (this.executor().inEventLoop());
        try {
            if (this.delayNanos() > 0L) {
                if (this.isCancelled()) {
                    this.scheduledExecutor().scheduledTaskQueue().removeTyped(this);
                } else {
                    this.scheduledExecutor().scheduleFromEventLoop(this);
                }
                return;
            }
            if (this.periodNanos == 0L) {
                if (this.setUncancellableInternal()) {
                    Object v = this.runTask();
                    this.setSuccessInternal(v);
                }
            } else if (!this.isCancelled()) {
                this.runTask();
                if (!this.executor().isShutdown()) {
                    this.deadlineNanos = this.periodNanos > 0L ? (this.deadlineNanos += this.periodNanos) : this.scheduledExecutor().getCurrentTimeNanos() - this.periodNanos;
                    if (!this.isCancelled()) {
                        this.scheduledExecutor().scheduledTaskQueue().add(this);
                    }
                }
            }
        }
        catch (Throwable throwable) {
            this.setFailureInternal(throwable);
        }
    }

    private AbstractScheduledEventExecutor scheduledExecutor() {
        return (AbstractScheduledEventExecutor)this.executor();
    }

    @Override
    public boolean cancel(boolean bl) {
        boolean bl2 = super.cancel(bl);
        if (bl2) {
            this.scheduledExecutor().removeScheduled(this);
        }
        return bl2;
    }

    boolean cancelWithoutRemove(boolean bl) {
        return super.cancel(bl);
    }

    @Override
    protected StringBuilder toStringBuilder() {
        StringBuilder stringBuilder = super.toStringBuilder();
        stringBuilder.setCharAt(stringBuilder.length() - 1, ',');
        return stringBuilder.append(" deadline: ").append(this.deadlineNanos).append(", period: ").append(this.periodNanos).append(')');
    }

    @Override
    public int priorityQueueIndex(DefaultPriorityQueue<?> defaultPriorityQueue) {
        return this.queueIndex;
    }

    @Override
    public void priorityQueueIndex(DefaultPriorityQueue<?> defaultPriorityQueue, int n) {
        this.queueIndex = n;
    }
}

