/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.util.collection;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import pro.gravit.repackage.io.netty.util.collection.ShortObjectHashMap$1;
import pro.gravit.repackage.io.netty.util.collection.ShortObjectHashMap$2;
import pro.gravit.repackage.io.netty.util.collection.ShortObjectHashMap$EntrySet;
import pro.gravit.repackage.io.netty.util.collection.ShortObjectHashMap$KeySet;
import pro.gravit.repackage.io.netty.util.collection.ShortObjectMap;
import pro.gravit.repackage.io.netty.util.collection.ShortObjectMap$PrimitiveEntry;
import pro.gravit.repackage.io.netty.util.internal.MathUtil;

public class ShortObjectHashMap<V>
implements ShortObjectMap<V> {
    public static final int DEFAULT_CAPACITY = 8;
    public static final float DEFAULT_LOAD_FACTOR = 0.5f;
    private static final Object NULL_VALUE = new Object();
    private int maxSize;
    private final float loadFactor;
    private short[] keys;
    private V[] values;
    private int size;
    private int mask;
    private final Set<Short> keySet = new ShortObjectHashMap$KeySet(this, null);
    private final Set<Map.Entry<Short, V>> entrySet = new ShortObjectHashMap$EntrySet(this, null);
    private final Iterable<ShortObjectMap$PrimitiveEntry<V>> entries = new ShortObjectHashMap$1(this);

    public ShortObjectHashMap() {
        this(8, 0.5f);
    }

    public ShortObjectHashMap(int n) {
        this(n, 0.5f);
    }

    public ShortObjectHashMap(int n, float f) {
        if (f <= 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("loadFactor must be > 0 and <= 1");
        }
        this.loadFactor = f;
        int n2 = MathUtil.safeFindNextPositivePowerOfTwo(n);
        this.mask = n2 - 1;
        this.keys = new short[n2];
        Object[] objectArray = new Object[n2];
        this.values = objectArray;
        this.maxSize = this.calcMaxSize(n2);
    }

    private static <T> T toExternal(T t) {
        assert (t != null) : "null is not a legitimate internal value. Concurrent Modification?";
        return t == NULL_VALUE ? null : (T)t;
    }

    private static <T> T toInternal(T t) {
        return (T)(t == null ? NULL_VALUE : t);
    }

    @Override
    public V get(short s) {
        int n = this.indexOf(s);
        return n == -1 ? null : (V)ShortObjectHashMap.toExternal(this.values[n]);
    }

    @Override
    public V put(short s, V v) {
        int n;
        int n2 = n = this.hashIndex(s);
        do {
            if (this.values[n2] == null) {
                this.keys[n2] = s;
                this.values[n2] = ShortObjectHashMap.toInternal(v);
                this.growSize();
                return null;
            }
            if (this.keys[n2] != s) continue;
            V v2 = this.values[n2];
            this.values[n2] = ShortObjectHashMap.toInternal(v);
            return ShortObjectHashMap.toExternal(v2);
        } while ((n2 = this.probeNext(n2)) != n);
        throw new IllegalStateException("Unable to insert");
    }

    @Override
    public void putAll(Map<? extends Short, ? extends V> map) {
        if (map instanceof ShortObjectHashMap) {
            ShortObjectHashMap shortObjectHashMap = (ShortObjectHashMap)map;
            for (int i = 0; i < shortObjectHashMap.values.length; ++i) {
                V v = shortObjectHashMap.values[i];
                if (v == null) continue;
                this.put(shortObjectHashMap.keys[i], v);
            }
            return;
        }
        for (Map.Entry<Short, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(short s) {
        int n = this.indexOf(s);
        if (n == -1) {
            return null;
        }
        V v = this.values[n];
        this.removeAt(n);
        return ShortObjectHashMap.toExternal(v);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public void clear() {
        Arrays.fill(this.keys, (short)0);
        Arrays.fill(this.values, null);
        this.size = 0;
    }

    @Override
    public boolean containsKey(short s) {
        return this.indexOf(s) >= 0;
    }

    @Override
    public boolean containsValue(Object object) {
        Object object2 = ShortObjectHashMap.toInternal(object);
        for (V v : this.values) {
            if (v == null || !v.equals(object2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterable<ShortObjectMap$PrimitiveEntry<V>> entries() {
        return this.entries;
    }

    @Override
    public Collection<V> values() {
        return new ShortObjectHashMap$2(this);
    }

    @Override
    public int hashCode() {
        int n = this.size;
        for (short s : this.keys) {
            n ^= ShortObjectHashMap.hashCode(s);
        }
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ShortObjectMap)) {
            return false;
        }
        ShortObjectMap shortObjectMap = (ShortObjectMap)object;
        if (this.size != shortObjectMap.size()) {
            return false;
        }
        for (int i = 0; i < this.values.length; ++i) {
            V v = this.values[i];
            if (v == null) continue;
            short s = this.keys[i];
            Object v2 = shortObjectMap.get(s);
            if (!(v == NULL_VALUE ? v2 != null : !v.equals(v2))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsKey(Object object) {
        return this.containsKey(this.objectToKey(object));
    }

    @Override
    public V get(Object object) {
        return this.get(this.objectToKey(object));
    }

    @Override
    public V put(Short s, V v) {
        return this.put(this.objectToKey(s), v);
    }

    @Override
    public V remove(Object object) {
        return this.remove(this.objectToKey(object));
    }

    @Override
    public Set<Short> keySet() {
        return this.keySet;
    }

    @Override
    public Set<Map.Entry<Short, V>> entrySet() {
        return this.entrySet;
    }

    private short objectToKey(Object object) {
        return (Short)object;
    }

    private int indexOf(short s) {
        int n;
        int n2 = n = this.hashIndex(s);
        do {
            if (this.values[n2] == null) {
                return -1;
            }
            if (s != this.keys[n2]) continue;
            return n2;
        } while ((n2 = this.probeNext(n2)) != n);
        return -1;
    }

    private int hashIndex(short s) {
        return ShortObjectHashMap.hashCode(s) & this.mask;
    }

    private static int hashCode(short s) {
        return s;
    }

    private int probeNext(int n) {
        return n + 1 & this.mask;
    }

    private void growSize() {
        ++this.size;
        if (this.size > this.maxSize) {
            if (this.keys.length == Integer.MAX_VALUE) {
                throw new IllegalStateException("Max capacity reached at size=" + this.size);
            }
            this.rehash(this.keys.length << 1);
        }
    }

    private boolean removeAt(int n) {
        --this.size;
        this.keys[n] = 0;
        this.values[n] = null;
        int n2 = n;
        int n3 = this.probeNext(n);
        V v = this.values[n3];
        while (v != null) {
            short s = this.keys[n3];
            int n4 = this.hashIndex(s);
            if (n3 < n4 && (n4 <= n2 || n2 <= n3) || n4 <= n2 && n2 <= n3) {
                this.keys[n2] = s;
                this.values[n2] = v;
                this.keys[n3] = 0;
                this.values[n3] = null;
                n2 = n3;
            }
            n3 = this.probeNext(n3);
            v = this.values[n3];
        }
        return n2 != n;
    }

    private int calcMaxSize(int n) {
        int n2 = n - 1;
        return Math.min(n2, (int)((float)n * this.loadFactor));
    }

    private void rehash(int n) {
        short[] sArray = this.keys;
        V[] VArray = this.values;
        this.keys = new short[n];
        Object[] objectArray = new Object[n];
        this.values = objectArray;
        this.maxSize = this.calcMaxSize(n);
        this.mask = n - 1;
        block0: for (int i = 0; i < VArray.length; ++i) {
            V v = VArray[i];
            if (v == null) continue;
            short s = sArray[i];
            int n2 = this.hashIndex(s);
            while (true) {
                if (this.values[n2] == null) {
                    this.keys[n2] = s;
                    this.values[n2] = v;
                    continue block0;
                }
                n2 = this.probeNext(n2);
            }
        }
    }

    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder stringBuilder = new StringBuilder(4 * this.size);
        stringBuilder.append('{');
        boolean bl = true;
        for (int i = 0; i < this.values.length; ++i) {
            V v = this.values[i];
            if (v == null) continue;
            if (!bl) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(this.keyToString(this.keys[i])).append('=').append((Object)(v == this ? "(this Map)" : ShortObjectHashMap.toExternal(v)));
            bl = false;
        }
        return stringBuilder.append('}').toString();
    }

    protected String keyToString(short s) {
        return Short.toString(s);
    }

    static /* synthetic */ int access$300(ShortObjectHashMap shortObjectHashMap) {
        return shortObjectHashMap.size;
    }

    static /* synthetic */ Set access$500(ShortObjectHashMap shortObjectHashMap) {
        return shortObjectHashMap.entrySet;
    }

    static /* synthetic */ Object[] access$600(ShortObjectHashMap shortObjectHashMap) {
        return shortObjectHashMap.values;
    }

    static /* synthetic */ boolean access$700(ShortObjectHashMap shortObjectHashMap, int n) {
        return shortObjectHashMap.removeAt(n);
    }

    static /* synthetic */ short[] access$800(ShortObjectHashMap shortObjectHashMap) {
        return shortObjectHashMap.keys;
    }

    static /* synthetic */ Object access$900(Object object) {
        return ShortObjectHashMap.toExternal(object);
    }

    static /* synthetic */ Object access$1000(Object object) {
        return ShortObjectHashMap.toInternal(object);
    }
}

