/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.util;

import pro.gravit.repackage.io.netty.util.ReferenceCountUtil$ReleasingTask;
import pro.gravit.repackage.io.netty.util.ReferenceCounted;
import pro.gravit.repackage.io.netty.util.ResourceLeakDetector;
import pro.gravit.repackage.io.netty.util.ThreadDeathWatcher;
import pro.gravit.repackage.io.netty.util.internal.ObjectUtil;
import pro.gravit.repackage.io.netty.util.internal.logging.InternalLogger;
import pro.gravit.repackage.io.netty.util.internal.logging.InternalLoggerFactory;

public final class ReferenceCountUtil {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ReferenceCountUtil.class);

    public static <T> T retain(T t) {
        if (t instanceof ReferenceCounted) {
            return (T)((ReferenceCounted)t).retain();
        }
        return t;
    }

    public static <T> T retain(T t, int n) {
        ObjectUtil.checkPositive(n, "increment");
        if (t instanceof ReferenceCounted) {
            return (T)((ReferenceCounted)t).retain(n);
        }
        return t;
    }

    public static <T> T touch(T t) {
        if (t instanceof ReferenceCounted) {
            return (T)((ReferenceCounted)t).touch();
        }
        return t;
    }

    public static <T> T touch(T t, Object object) {
        if (t instanceof ReferenceCounted) {
            return (T)((ReferenceCounted)t).touch(object);
        }
        return t;
    }

    public static boolean release(Object object) {
        if (object instanceof ReferenceCounted) {
            return ((ReferenceCounted)object).release();
        }
        return false;
    }

    public static boolean release(Object object, int n) {
        ObjectUtil.checkPositive(n, "decrement");
        if (object instanceof ReferenceCounted) {
            return ((ReferenceCounted)object).release(n);
        }
        return false;
    }

    public static void safeRelease(Object object) {
        try {
            ReferenceCountUtil.release(object);
        }
        catch (Throwable throwable) {
            logger.warn("Failed to release a message: {}", object, (Object)throwable);
        }
    }

    public static void safeRelease(Object object, int n) {
        block2: {
            try {
                ObjectUtil.checkPositive(n, "decrement");
                ReferenceCountUtil.release(object, n);
            }
            catch (Throwable throwable) {
                if (!logger.isWarnEnabled()) break block2;
                logger.warn("Failed to release a message: {} (decrement: {})", object, n, throwable);
            }
        }
    }

    @Deprecated
    public static <T> T releaseLater(T t) {
        return ReferenceCountUtil.releaseLater(t, 1);
    }

    @Deprecated
    public static <T> T releaseLater(T t, int n) {
        ObjectUtil.checkPositive(n, "decrement");
        if (t instanceof ReferenceCounted) {
            ThreadDeathWatcher.watch(Thread.currentThread(), new ReferenceCountUtil$ReleasingTask((ReferenceCounted)t, n));
        }
        return t;
    }

    public static int refCnt(Object object) {
        return object instanceof ReferenceCounted ? ((ReferenceCounted)object).refCnt() : -1;
    }

    private ReferenceCountUtil() {
    }

    static /* synthetic */ InternalLogger access$000() {
        return logger;
    }

    static {
        ResourceLeakDetector.addExclusions(ReferenceCountUtil.class, "touch");
    }
}

