/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.handler.ssl.util;

import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Pattern;
import javax.net.ssl.ManagerFactoryParameters;
import javax.net.ssl.TrustManager;
import pro.gravit.repackage.io.netty.buffer.ByteBufUtil;
import pro.gravit.repackage.io.netty.buffer.Unpooled;
import pro.gravit.repackage.io.netty.handler.ssl.util.FingerprintTrustManagerFactory$1;
import pro.gravit.repackage.io.netty.handler.ssl.util.FingerprintTrustManagerFactory$2;
import pro.gravit.repackage.io.netty.handler.ssl.util.FingerprintTrustManagerFactoryBuilder;
import pro.gravit.repackage.io.netty.handler.ssl.util.SimpleTrustManagerFactory;
import pro.gravit.repackage.io.netty.util.concurrent.FastThreadLocal;
import pro.gravit.repackage.io.netty.util.internal.ObjectUtil;
import pro.gravit.repackage.io.netty.util.internal.StringUtil;

public final class FingerprintTrustManagerFactory
extends SimpleTrustManagerFactory {
    private static final Pattern FINGERPRINT_PATTERN = Pattern.compile("^[0-9a-fA-F:]+$");
    private static final Pattern FINGERPRINT_STRIP_PATTERN = Pattern.compile(":");
    private final FastThreadLocal<MessageDigest> tlmd;
    private final TrustManager tm = new FingerprintTrustManagerFactory$1(this);
    private final byte[][] fingerprints;

    public static FingerprintTrustManagerFactoryBuilder builder(String string) {
        return new FingerprintTrustManagerFactoryBuilder(string);
    }

    @Deprecated
    public FingerprintTrustManagerFactory(Iterable<String> iterable) {
        this("SHA1", FingerprintTrustManagerFactory.toFingerprintArray(iterable));
    }

    @Deprecated
    public FingerprintTrustManagerFactory(String ... stringArray) {
        this("SHA1", FingerprintTrustManagerFactory.toFingerprintArray(Arrays.asList(stringArray)));
    }

    @Deprecated
    public FingerprintTrustManagerFactory(byte[] ... byArray) {
        this("SHA1", byArray);
    }

    FingerprintTrustManagerFactory(String string, byte[][] byArray) {
        MessageDigest messageDigest;
        ObjectUtil.checkNotNull(string, "algorithm");
        ObjectUtil.checkNotNull(byArray, "fingerprints");
        if (byArray.length == 0) {
            throw new IllegalArgumentException("No fingerprints provided");
        }
        try {
            messageDigest = MessageDigest.getInstance(string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IllegalArgumentException(String.format("Unsupported hash algorithm: %s", string), noSuchAlgorithmException);
        }
        int n = messageDigest.getDigestLength();
        ArrayList<Object> arrayList = new ArrayList<Object>(byArray.length);
        for (byte[] byArray2 : byArray) {
            if (byArray2 == null) break;
            if (byArray2.length != n) {
                throw new IllegalArgumentException(String.format("malformed fingerprint (length is %d but expected %d): %s", byArray2.length, n, ByteBufUtil.hexDump(Unpooled.wrappedBuffer(byArray2))));
            }
            arrayList.add(byArray2.clone());
        }
        this.tlmd = new FingerprintTrustManagerFactory$2(this, string);
        this.fingerprints = (byte[][])arrayList.toArray((T[])new byte[0][]);
    }

    static byte[][] toFingerprintArray(Iterable<String> iterable) {
        ObjectUtil.checkNotNull(iterable, "fingerprints");
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        for (String string : iterable) {
            if (string == null) break;
            if (!FINGERPRINT_PATTERN.matcher(string).matches()) {
                throw new IllegalArgumentException("malformed fingerprint: " + string);
            }
            string = FINGERPRINT_STRIP_PATTERN.matcher(string).replaceAll("");
            arrayList.add(StringUtil.decodeHexDump(string));
        }
        return (byte[][])arrayList.toArray((T[])new byte[0][]);
    }

    @Override
    protected void engineInit(KeyStore keyStore) {
    }

    @Override
    protected void engineInit(ManagerFactoryParameters managerFactoryParameters) {
    }

    @Override
    protected TrustManager[] engineGetTrustManagers() {
        return new TrustManager[]{this.tm};
    }

    static /* synthetic */ byte[][] access$000(FingerprintTrustManagerFactory fingerprintTrustManagerFactory) {
        return fingerprintTrustManagerFactory.fingerprints;
    }

    static /* synthetic */ FastThreadLocal access$100(FingerprintTrustManagerFactory fingerprintTrustManagerFactory) {
        return fingerprintTrustManagerFactory.tlmd;
    }
}

