/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.handler.ssl;

import java.security.Principal;
import java.security.cert.Certificate;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSessionBindingEvent;
import javax.net.ssl.SSLSessionBindingListener;
import javax.security.cert.X509Certificate;
import pro.gravit.repackage.io.netty.handler.ssl.OpenSsl;
import pro.gravit.repackage.io.netty.handler.ssl.OpenSslSession;
import pro.gravit.repackage.io.netty.handler.ssl.OpenSslSessionContext;
import pro.gravit.repackage.io.netty.handler.ssl.OpenSslSessionId;
import pro.gravit.repackage.io.netty.handler.ssl.ReferenceCountedOpenSslEngine;
import pro.gravit.repackage.io.netty.handler.ssl.ReferenceCountedOpenSslEngine$HandshakeState;
import pro.gravit.repackage.io.netty.handler.ssl.util.LazyJavaxX509Certificate;
import pro.gravit.repackage.io.netty.handler.ssl.util.LazyX509Certificate;
import pro.gravit.repackage.io.netty.internal.tcnative.SSL;
import pro.gravit.repackage.io.netty.util.internal.EmptyArrays;
import pro.gravit.repackage.io.netty.util.internal.ObjectUtil;

final class ReferenceCountedOpenSslEngine$DefaultOpenSslSession
implements OpenSslSession {
    private final OpenSslSessionContext sessionContext;
    private X509Certificate[] x509PeerCerts;
    private Certificate[] peerCerts;
    private boolean valid = true;
    private String protocol;
    private String cipher;
    private OpenSslSessionId id = OpenSslSessionId.NULL_ID;
    private volatile long creationTime;
    private volatile int applicationBufferSize = ReferenceCountedOpenSslEngine.MAX_PLAINTEXT_LENGTH;
    private volatile Certificate[] localCertificateChain;
    private Map<String, Object> values;
    final /* synthetic */ ReferenceCountedOpenSslEngine this$0;

    ReferenceCountedOpenSslEngine$DefaultOpenSslSession(ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine, OpenSslSessionContext openSslSessionContext) {
        this.this$0 = referenceCountedOpenSslEngine;
        this.sessionContext = openSslSessionContext;
    }

    private SSLSessionBindingEvent newSSLSessionBindingEvent(String string) {
        return new SSLSessionBindingEvent(ReferenceCountedOpenSslEngine.access$800(this.this$0), string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSessionId(OpenSslSessionId openSslSessionId) {
        ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this.this$0;
        synchronized (referenceCountedOpenSslEngine) {
            if (this.id == OpenSslSessionId.NULL_ID) {
                this.id = openSslSessionId;
                this.creationTime = System.currentTimeMillis();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OpenSslSessionId sessionId() {
        ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this.this$0;
        synchronized (referenceCountedOpenSslEngine) {
            byte[] byArray;
            if (this.id == OpenSslSessionId.NULL_ID && !ReferenceCountedOpenSslEngine.access$400(this.this$0) && (byArray = SSL.getSessionId((long)ReferenceCountedOpenSslEngine.access$500(this.this$0))) != null) {
                this.id = new OpenSslSessionId(byArray);
            }
            return this.id;
        }
    }

    @Override
    public void setLocalCertificate(Certificate[] certificateArray) {
        this.localCertificateChain = certificateArray;
    }

    @Override
    public byte[] getId() {
        return this.sessionId().cloneBytes();
    }

    @Override
    public OpenSslSessionContext getSessionContext() {
        return this.sessionContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getCreationTime() {
        ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this.this$0;
        synchronized (referenceCountedOpenSslEngine) {
            return this.creationTime;
        }
    }

    @Override
    public long getLastAccessedTime() {
        long l = ReferenceCountedOpenSslEngine.access$900(this.this$0);
        return l == -1L ? this.getCreationTime() : l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidate() {
        ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this.this$0;
        synchronized (referenceCountedOpenSslEngine) {
            this.valid = false;
            this.sessionContext.removeFromCache(this.id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isValid() {
        ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this.this$0;
        synchronized (referenceCountedOpenSslEngine) {
            return this.valid || this.sessionContext.isInCache(this.id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putValue(String string, Object object) {
        Object object2;
        ObjectUtil.checkNotNull(string, "name");
        ObjectUtil.checkNotNull(object, "value");
        ReferenceCountedOpenSslEngine$DefaultOpenSslSession referenceCountedOpenSslEngine$DefaultOpenSslSession = this;
        synchronized (referenceCountedOpenSslEngine$DefaultOpenSslSession) {
            Map<String, Object> map = this.values;
            if (map == null) {
                map = this.values = new HashMap<String, Object>(2);
            }
            object2 = map.put(string, object);
        }
        if (object instanceof SSLSessionBindingListener) {
            ((SSLSessionBindingListener)object).valueBound(this.newSSLSessionBindingEvent(string));
        }
        this.notifyUnbound(object2, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getValue(String string) {
        ObjectUtil.checkNotNull(string, "name");
        ReferenceCountedOpenSslEngine$DefaultOpenSslSession referenceCountedOpenSslEngine$DefaultOpenSslSession = this;
        synchronized (referenceCountedOpenSslEngine$DefaultOpenSslSession) {
            if (this.values == null) {
                return null;
            }
            return this.values.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeValue(String string) {
        Object object;
        ObjectUtil.checkNotNull(string, "name");
        ReferenceCountedOpenSslEngine$DefaultOpenSslSession referenceCountedOpenSslEngine$DefaultOpenSslSession = this;
        synchronized (referenceCountedOpenSslEngine$DefaultOpenSslSession) {
            Map<String, Object> map = this.values;
            if (map == null) {
                return;
            }
            object = map.remove(string);
        }
        this.notifyUnbound(object, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getValueNames() {
        ReferenceCountedOpenSslEngine$DefaultOpenSslSession referenceCountedOpenSslEngine$DefaultOpenSslSession = this;
        synchronized (referenceCountedOpenSslEngine$DefaultOpenSslSession) {
            Map<String, Object> map = this.values;
            if (map == null || map.isEmpty()) {
                return EmptyArrays.EMPTY_STRINGS;
            }
            return map.keySet().toArray(EmptyArrays.EMPTY_STRINGS);
        }
    }

    private void notifyUnbound(Object object, String string) {
        if (object instanceof SSLSessionBindingListener) {
            ((SSLSessionBindingListener)object).valueUnbound(this.newSSLSessionBindingEvent(string));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handshakeFinished(byte[] byArray, String string, String string2, byte[] byArray2, byte[][] byArray3, long l, long l2) {
        ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this.this$0;
        synchronized (referenceCountedOpenSslEngine) {
            if (!ReferenceCountedOpenSslEngine.access$400(this.this$0)) {
                this.creationTime = l;
                if (this.id == OpenSslSessionId.NULL_ID) {
                    this.id = byArray == null ? OpenSslSessionId.NULL_ID : new OpenSslSessionId(byArray);
                }
                this.cipher = ReferenceCountedOpenSslEngine.access$1000(this.this$0, string);
                this.protocol = string2;
                if (ReferenceCountedOpenSslEngine.access$200(this.this$0)) {
                    if (ReferenceCountedOpenSslEngine.access$1100((Object[])byArray3)) {
                        this.peerCerts = EmptyArrays.EMPTY_CERTIFICATES;
                        this.x509PeerCerts = OpenSsl.JAVAX_CERTIFICATE_CREATION_SUPPORTED ? EmptyArrays.EMPTY_JAVAX_X509_CERTIFICATES : ReferenceCountedOpenSslEngine.access$1200();
                    } else {
                        this.peerCerts = new Certificate[byArray3.length];
                        this.x509PeerCerts = OpenSsl.JAVAX_CERTIFICATE_CREATION_SUPPORTED ? new X509Certificate[byArray3.length] : ReferenceCountedOpenSslEngine.access$1200();
                        this.initCerts(byArray3, 0);
                    }
                } else if (ReferenceCountedOpenSslEngine.access$1300(byArray2)) {
                    this.peerCerts = EmptyArrays.EMPTY_CERTIFICATES;
                    this.x509PeerCerts = EmptyArrays.EMPTY_JAVAX_X509_CERTIFICATES;
                } else if (ReferenceCountedOpenSslEngine.access$1100((Object[])byArray3)) {
                    this.peerCerts = new Certificate[]{new LazyX509Certificate(byArray2)};
                    this.x509PeerCerts = OpenSsl.JAVAX_CERTIFICATE_CREATION_SUPPORTED ? new X509Certificate[]{new LazyJavaxX509Certificate(byArray2)} : ReferenceCountedOpenSslEngine.access$1200();
                } else {
                    this.peerCerts = new Certificate[byArray3.length + 1];
                    this.peerCerts[0] = new LazyX509Certificate(byArray2);
                    if (OpenSsl.JAVAX_CERTIFICATE_CREATION_SUPPORTED) {
                        this.x509PeerCerts = new X509Certificate[byArray3.length + 1];
                        this.x509PeerCerts[0] = new LazyJavaxX509Certificate(byArray2);
                    } else {
                        this.x509PeerCerts = ReferenceCountedOpenSslEngine.access$1200();
                    }
                    this.initCerts(byArray3, 1);
                }
            } else {
                throw new SSLException("Already closed");
            }
            ReferenceCountedOpenSslEngine.access$1400(this.this$0);
            ReferenceCountedOpenSslEngine.access$1502(this.this$0, ReferenceCountedOpenSslEngine$HandshakeState.FINISHED);
        }
    }

    private void initCerts(byte[][] byArray, int n) {
        for (int i = 0; i < byArray.length; ++i) {
            int n2 = n + i;
            this.peerCerts[n2] = new LazyX509Certificate(byArray[i]);
            if (this.x509PeerCerts == ReferenceCountedOpenSslEngine.access$1200()) continue;
            this.x509PeerCerts[n2] = new LazyJavaxX509Certificate(byArray[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Certificate[] getPeerCertificates() {
        ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this.this$0;
        synchronized (referenceCountedOpenSslEngine) {
            if (ReferenceCountedOpenSslEngine.access$1100(this.peerCerts)) {
                throw new SSLPeerUnverifiedException("peer not verified");
            }
            return (Certificate[])this.peerCerts.clone();
        }
    }

    @Override
    public Certificate[] getLocalCertificates() {
        Certificate[] certificateArray = this.localCertificateChain;
        if (certificateArray == null) {
            return null;
        }
        return (Certificate[])certificateArray.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public X509Certificate[] getPeerCertificateChain() {
        ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this.this$0;
        synchronized (referenceCountedOpenSslEngine) {
            if (this.x509PeerCerts == ReferenceCountedOpenSslEngine.access$1200()) {
                throw new UnsupportedOperationException();
            }
            if (ReferenceCountedOpenSslEngine.access$1100(this.x509PeerCerts)) {
                throw new SSLPeerUnverifiedException("peer not verified");
            }
            return (X509Certificate[])this.x509PeerCerts.clone();
        }
    }

    @Override
    public Principal getPeerPrincipal() {
        Certificate[] certificateArray = this.getPeerCertificates();
        return ((java.security.cert.X509Certificate)certificateArray[0]).getSubjectX500Principal();
    }

    @Override
    public Principal getLocalPrincipal() {
        Certificate[] certificateArray = this.localCertificateChain;
        if (certificateArray == null || certificateArray.length == 0) {
            return null;
        }
        return ((java.security.cert.X509Certificate)certificateArray[0]).getSubjectX500Principal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getCipherSuite() {
        ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this.this$0;
        synchronized (referenceCountedOpenSslEngine) {
            if (this.cipher == null) {
                return "SSL_NULL_WITH_NULL_NULL";
            }
            return this.cipher;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getProtocol() {
        String string = this.protocol;
        if (string == null) {
            ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this.this$0;
            synchronized (referenceCountedOpenSslEngine) {
                string = !ReferenceCountedOpenSslEngine.access$400(this.this$0) ? SSL.getVersion((long)ReferenceCountedOpenSslEngine.access$500(this.this$0)) : "";
            }
        }
        return string;
    }

    @Override
    public String getPeerHost() {
        return this.this$0.getPeerHost();
    }

    @Override
    public int getPeerPort() {
        return this.this$0.getPeerPort();
    }

    @Override
    public int getPacketBufferSize() {
        return SSL.SSL_MAX_ENCRYPTED_LENGTH;
    }

    @Override
    public int getApplicationBufferSize() {
        return this.applicationBufferSize;
    }

    @Override
    public void tryExpandApplicationBufferSize(int n) {
        if (n > ReferenceCountedOpenSslEngine.MAX_PLAINTEXT_LENGTH && this.applicationBufferSize != ReferenceCountedOpenSslEngine.MAX_RECORD_SIZE) {
            this.applicationBufferSize = ReferenceCountedOpenSslEngine.MAX_RECORD_SIZE;
        }
    }

    public String toString() {
        return "DefaultOpenSslSession{sessionContext=" + this.sessionContext + ", id=" + this.id + '}';
    }
}

