/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.handler.ssl;

import java.security.cert.CertPathValidatorException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CertificateRevokedException;
import java.security.cert.X509Certificate;
import pro.gravit.repackage.io.netty.handler.ssl.OpenSslCertificateException;
import pro.gravit.repackage.io.netty.handler.ssl.OpenSslEngineMap;
import pro.gravit.repackage.io.netty.handler.ssl.ReferenceCountedOpenSslContext;
import pro.gravit.repackage.io.netty.handler.ssl.ReferenceCountedOpenSslEngine;
import pro.gravit.repackage.io.netty.internal.tcnative.CertificateVerifier;
import pro.gravit.repackage.io.netty.util.internal.PlatformDependent;
import pro.gravit.repackage.io.netty.util.internal.SuppressJava6Requirement;

abstract class ReferenceCountedOpenSslContext$AbstractCertificateVerifier
extends CertificateVerifier {
    private final OpenSslEngineMap engineMap;

    ReferenceCountedOpenSslContext$AbstractCertificateVerifier(OpenSslEngineMap openSslEngineMap) {
        this.engineMap = openSslEngineMap;
    }

    public final int verify(long l, byte[][] byArray, String string) {
        ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this.engineMap.get(l);
        if (referenceCountedOpenSslEngine == null) {
            return CertificateVerifier.X509_V_ERR_UNSPECIFIED;
        }
        X509Certificate[] x509CertificateArray = ReferenceCountedOpenSslContext.certificates(byArray);
        try {
            this.verify(referenceCountedOpenSslEngine, x509CertificateArray, string);
            return CertificateVerifier.X509_V_OK;
        }
        catch (Throwable throwable) {
            ReferenceCountedOpenSslContext.access$300().debug("verification of certificate failed", throwable);
            referenceCountedOpenSslEngine.initHandshakeException(throwable);
            if (throwable instanceof OpenSslCertificateException) {
                return ((OpenSslCertificateException)throwable).errorCode();
            }
            if (throwable instanceof CertificateExpiredException) {
                return CertificateVerifier.X509_V_ERR_CERT_HAS_EXPIRED;
            }
            if (throwable instanceof CertificateNotYetValidException) {
                return CertificateVerifier.X509_V_ERR_CERT_NOT_YET_VALID;
            }
            if (PlatformDependent.javaVersion() >= 7) {
                return ReferenceCountedOpenSslContext$AbstractCertificateVerifier.translateToError(throwable);
            }
            return CertificateVerifier.X509_V_ERR_UNSPECIFIED;
        }
    }

    @SuppressJava6Requirement(reason="Usage guarded by java version check")
    private static int translateToError(Throwable throwable) {
        if (throwable instanceof CertificateRevokedException) {
            return CertificateVerifier.X509_V_ERR_CERT_REVOKED;
        }
        for (Throwable throwable2 = throwable.getCause(); throwable2 != null; throwable2 = throwable2.getCause()) {
            if (!(throwable2 instanceof CertPathValidatorException)) continue;
            CertPathValidatorException certPathValidatorException = (CertPathValidatorException)throwable2;
            CertPathValidatorException.Reason reason = certPathValidatorException.getReason();
            if (reason == CertPathValidatorException.BasicReason.EXPIRED) {
                return CertificateVerifier.X509_V_ERR_CERT_HAS_EXPIRED;
            }
            if (reason == CertPathValidatorException.BasicReason.NOT_YET_VALID) {
                return CertificateVerifier.X509_V_ERR_CERT_NOT_YET_VALID;
            }
            if (reason != CertPathValidatorException.BasicReason.REVOKED) continue;
            return CertificateVerifier.X509_V_ERR_CERT_REVOKED;
        }
        return CertificateVerifier.X509_V_ERR_UNSPECIFIED;
    }

    abstract void verify(ReferenceCountedOpenSslEngine var1, X509Certificate[] var2, String var3);
}

