/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.api;

import de.jcm.discordgamesdk.Core;
import de.jcm.discordgamesdk.activity.Activity;
import de.jcm.discordgamesdk.activity.ActivityButton;
import de.jcm.discordgamesdk.activity.ActivityButtonsMode;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import pro.gravit.launcher.CRAftUA6AiyzCl;
import pro.gravit.launcher.CrAFtUagzKiLWV;
import pro.gravit.launcher.cRAftuAgi17rAU;
import pro.gravit.launcher.crAftUariTRUOg;
import pro.gravit.launcher.profiles.PlayerProfile;
import pro.gravit.utils.Version;
import pro.gravit.utils.helper.JVMHelper;
import pro.gravit.utils.helper.LogHelper;

public class DiscordActivityService {
    private final Map<String, String> params = new ConcurrentHashMap<String, String>();
    private String details;
    private String state;
    private String largeKey;
    private String smallKey;
    private String largeText;
    private String smallText;
    private String partyId;
    private int partySize;
    private int partyMaxSize;
    private final List<ActivityButton> buttons = new ArrayList<ActivityButton>(2);

    public DiscordActivityService() {
        this.setParam("launcherVersion", Version.getVersion().getVersionString());
        this.setParam("javaVersion", Integer.toString(JVMHelper.JVM_VERSION));
        this.setParam("javaBits", Integer.toString(JVMHelper.JVM_BITS));
        this.setParam("os", JVMHelper.OS_TYPE.name);
    }

    public void applyToActivity(Activity activity) {
        if (this.details != null) {
            activity.setDetails(this.details);
        }
        if (this.state != null) {
            activity.setState(this.state);
        }
        if (this.largeKey != null) {
            activity.assets().setLargeImage(this.largeKey);
        }
        if (this.smallKey != null) {
            activity.assets().setSmallImage(this.smallKey);
        }
        if (this.smallText != null) {
            activity.assets().setSmallText(this.smallText);
        }
        if (this.largeText != null) {
            activity.assets().setLargeText(this.largeText);
        }
        if (this.partyId != null) {
            activity.party().setID(this.partyId);
        }
        if (this.partyMaxSize != 0) {
            activity.party().size().setCurrentSize(this.partySize);
            activity.party().size().setMaxSize(this.partyMaxSize);
        }
        if (!this.buttons.isEmpty()) {
            activity.setActivityButtonsMode(ActivityButtonsMode.BUTTONS);
            ArrayList<ActivityButton> arrayList = new ArrayList<ActivityButton>(activity.getButtons());
            for (ActivityButton activityButton : arrayList) {
                activity.removeButton(activityButton);
            }
            for (ActivityButton activityButton : this.buttons) {
                activity.addButton(activityButton);
            }
        }
    }

    public void updateActivity() {
        Core core = crAftUariTRUOg.cRaftUAHO1bfAE();
        if (core == null) {
            return;
        }
        this.applyToActivity(crAftUariTRUOg.cRAfTuARPtQgOI());
        core.activityManager().updateActivity(crAftUariTRUOg.cRAfTuARPtQgOI());
    }

    public String getDetails() {
        return this.details;
    }

    public void setDetails(String string) {
        this.details = this.replaceParams(string);
    }

    public String getState() {
        return this.state;
    }

    public void setState(String string) {
        this.state = this.replaceParams(string);
    }

    public String getLargeKey() {
        return this.largeKey;
    }

    public void setLargeKey(String string) {
        this.largeKey = this.replaceParams(string);
    }

    public String getSmallKey() {
        return this.smallKey;
    }

    public void setSmallKey(String string) {
        this.smallKey = this.replaceParams(string);
    }

    public String getLargeText() {
        return this.largeText;
    }

    public void setLargeText(String string) {
        this.largeText = this.replaceParams(string);
    }

    public String getSmallText() {
        return this.smallText;
    }

    public void setSmallText(String string) {
        this.smallText = this.replaceParams(string);
    }

    public String getPartyId() {
        return this.partyId;
    }

    public void setPartyId(String string) {
        this.partyId = this.replaceParams(string);
        this.updateActivity();
    }

    public int getPartySize() {
        return this.partySize;
    }

    public void setPartySize(int n) {
        this.partySize = n;
        this.updateActivity();
    }

    public int getPartyMaxSize() {
        return this.partyMaxSize;
    }

    public void setPartyMaxSize(int n) {
        this.partyMaxSize = n;
        this.updateActivity();
    }

    public void setParam(String string, String string2) {
        String string3 = this.params.put(string, string2);
        if (string3 != null) {
            this.updateActivity();
        }
    }

    public void addButton(ActivityButton activityButton) {
        this.buttons.add(activityButton);
    }

    public void clearButtons() {
        this.buttons.clear();
    }

    public String getParam(String string) {
        return this.params.get(string);
    }

    public Map<String, String> getUnmodifiableParamsMap() {
        return Collections.unmodifiableMap(this.params);
    }

    public String replaceParams(String string) {
        if (string == null) {
            return null;
        }
        String string2 = string;
        for (Map.Entry<String, String> entry : this.params.entrySet()) {
            if (entry.getValue() == null) {
                LogHelper.warning("DiscordGame: Param %s null", entry.getKey());
                continue;
            }
            string2 = string2.replaceAll("%" + entry.getKey() + "%", entry.getValue());
        }
        return string2;
    }

    public void updateLoginStage() {
        this.setParam("username", "");
        this.setParam("uuid", "");
        this.setScope(cRAftuAgi17rAU.crAFtuaz7zAMI8);
    }

    public void updateAuthorizedStage(PlayerProfile playerProfile) {
        this.onPlayerProfile(playerProfile);
        this.setScope(cRAftuAgi17rAU.CRaFtuA2XCz3YY);
    }

    public void updateClientStage(CrAFtUagzKiLWV crAFtUagzKiLWV) {
        this.setParam("profileVersion", crAFtUagzKiLWV.cRaFTUA1F4MMik.getVersion().toString());
        this.setParam("profileName", crAFtUagzKiLWV.cRaFTUA1F4MMik.getTitle());
        this.setParam("profileUUID", crAFtUagzKiLWV.cRaFTUA1F4MMik.getUUID().toString());
        this.setParam("profileHash", crAFtUagzKiLWV.cRaFTUA1F4MMik.getUUID().toString().replaceAll("-", ""));
        this.onPlayerProfile(crAFtUagzKiLWV.crAFtua3vUWrs4);
        this.setScope(cRAftuAgi17rAU.CRaftUatDqCE4i);
    }

    public void onPlayerProfile(PlayerProfile playerProfile) {
        this.setParam("username", playerProfile.username);
        this.setParam("uuid", playerProfile.uuid.toString());
    }

    private void setScope(CRAftUA6AiyzCl cRAftUA6AiyzCl) {
        LogHelper.dev(cRAftUA6AiyzCl.toString());
        this.setDetails(cRAftUA6AiyzCl.cRaftUAHO1bfAE());
        this.setState(cRAftUA6AiyzCl.cRAfTuARPtQgOI());
        this.setLargeKey(cRAftUA6AiyzCl.cRAFtUAMpE6uzB());
        this.setLargeText(cRAftUA6AiyzCl.crAFtua3vUWrs4());
        this.setSmallKey(cRAftUA6AiyzCl.CRAfTuatjwFyZz());
        this.setSmallText(cRAftUA6AiyzCl.cRaFTUA1F4MMik());
        this.clearButtons();
        if (cRAftUA6AiyzCl.crAFtuaz7zAMI8()) {
            this.addButton(new ActivityButton(cRAftUA6AiyzCl.CRaFtuA2XCz3YY(), cRAftUA6AiyzCl.CRaftUatDqCE4i()));
        }
        if (cRAftUA6AiyzCl.cRAFtuakilDQT8()) {
            this.addButton(new ActivityButton(cRAftUA6AiyzCl.cRAFTUAlVRY6eh(), cRAftUA6AiyzCl.CRaftUA9jFYp3O()));
        }
        this.updateActivity();
    }

    public void resetStartTime() {
        crAftUariTRUOg.cRAfTuARPtQgOI().timestamps().setStart(Instant.now());
    }
}

