/*
 * Decompiled with CFR 0.152.
 */
package oshi.util.platform.windows;

import com.sun.jna.platform.win32.COM.WbemcliUtil;
import java.time.OffsetDateTime;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.util.Constants;
import oshi.util.ParseUtil;

@ThreadSafe
public final class WmiUtil {
    public static final String OHM_NAMESPACE = "ROOT\\OpenHardwareMonitor";
    private static final String CLASS_CAST_MSG = "%s is not a %s type. CIM Type is %d and VT type is %d";

    private WmiUtil() {
    }

    public static <T extends Enum<T>> String queryToString(WbemcliUtil.WmiQuery<T> wmiQuery) {
        Enum[] enumArray = (Enum[])wmiQuery.getPropertyEnum().getEnumConstants();
        StringBuilder stringBuilder = new StringBuilder("SELECT ");
        stringBuilder.append(enumArray[0].name());
        for (int i = 1; i < enumArray.length; ++i) {
            stringBuilder.append(',').append(enumArray[i].name());
        }
        stringBuilder.append(" FROM ").append(wmiQuery.getWmiClassName());
        return stringBuilder.toString();
    }

    public static <T extends Enum<T>> String getString(WbemcliUtil.WmiResult<T> wmiResult, T t, int n) {
        if (wmiResult.getCIMType(t) == 8) {
            return WmiUtil.getStr(wmiResult, t, n);
        }
        throw new ClassCastException(String.format(CLASS_CAST_MSG, t.name(), "String", wmiResult.getCIMType(t), wmiResult.getVtType(t)));
    }

    public static <T extends Enum<T>> String getDateString(WbemcliUtil.WmiResult<T> wmiResult, T t, int n) {
        OffsetDateTime offsetDateTime = WmiUtil.getDateTime(wmiResult, t, n);
        if (offsetDateTime.equals(Constants.UNIX_EPOCH)) {
            return "";
        }
        return offsetDateTime.toLocalDate().toString();
    }

    public static <T extends Enum<T>> OffsetDateTime getDateTime(WbemcliUtil.WmiResult<T> wmiResult, T t, int n) {
        if (wmiResult.getCIMType(t) == 101) {
            return ParseUtil.parseCimDateTimeToOffset(WmiUtil.getStr(wmiResult, t, n));
        }
        throw new ClassCastException(String.format(CLASS_CAST_MSG, t.name(), "DateTime", wmiResult.getCIMType(t), wmiResult.getVtType(t)));
    }

    public static <T extends Enum<T>> String getRefString(WbemcliUtil.WmiResult<T> wmiResult, T t, int n) {
        if (wmiResult.getCIMType(t) == 102) {
            return WmiUtil.getStr(wmiResult, t, n);
        }
        throw new ClassCastException(String.format(CLASS_CAST_MSG, t.name(), "Reference", wmiResult.getCIMType(t), wmiResult.getVtType(t)));
    }

    private static <T extends Enum<T>> String getStr(WbemcliUtil.WmiResult<T> wmiResult, T t, int n) {
        Object object = wmiResult.getValue(t, n);
        if (object == null) {
            return "";
        }
        if (wmiResult.getVtType(t) == 8) {
            return (String)object;
        }
        throw new ClassCastException(String.format(CLASS_CAST_MSG, t.name(), "String-mapped", wmiResult.getCIMType(t), wmiResult.getVtType(t)));
    }

    public static <T extends Enum<T>> long getUint64(WbemcliUtil.WmiResult<T> wmiResult, T t, int n) {
        Object object = wmiResult.getValue(t, n);
        if (object == null) {
            return 0L;
        }
        if (wmiResult.getCIMType(t) == 21 && wmiResult.getVtType(t) == 8) {
            return ParseUtil.parseLongOrDefault((String)object, 0L);
        }
        throw new ClassCastException(String.format(CLASS_CAST_MSG, t.name(), "UINT64", wmiResult.getCIMType(t), wmiResult.getVtType(t)));
    }

    public static <T extends Enum<T>> int getUint32(WbemcliUtil.WmiResult<T> wmiResult, T t, int n) {
        if (wmiResult.getCIMType(t) == 19) {
            return WmiUtil.getInt(wmiResult, t, n);
        }
        throw new ClassCastException(String.format(CLASS_CAST_MSG, t.name(), "UINT32", wmiResult.getCIMType(t), wmiResult.getVtType(t)));
    }

    public static <T extends Enum<T>> long getUint32asLong(WbemcliUtil.WmiResult<T> wmiResult, T t, int n) {
        if (wmiResult.getCIMType(t) == 19) {
            return (long)WmiUtil.getInt(wmiResult, t, n) & 0xFFFFFFFFL;
        }
        throw new ClassCastException(String.format(CLASS_CAST_MSG, t.name(), "UINT32", wmiResult.getCIMType(t), wmiResult.getVtType(t)));
    }

    public static <T extends Enum<T>> int getSint32(WbemcliUtil.WmiResult<T> wmiResult, T t, int n) {
        if (wmiResult.getCIMType(t) == 3) {
            return WmiUtil.getInt(wmiResult, t, n);
        }
        throw new ClassCastException(String.format(CLASS_CAST_MSG, t.name(), "SINT32", wmiResult.getCIMType(t), wmiResult.getVtType(t)));
    }

    public static <T extends Enum<T>> int getUint16(WbemcliUtil.WmiResult<T> wmiResult, T t, int n) {
        if (wmiResult.getCIMType(t) == 18) {
            return WmiUtil.getInt(wmiResult, t, n);
        }
        throw new ClassCastException(String.format(CLASS_CAST_MSG, t.name(), "UINT16", wmiResult.getCIMType(t), wmiResult.getVtType(t)));
    }

    private static <T extends Enum<T>> int getInt(WbemcliUtil.WmiResult<T> wmiResult, T t, int n) {
        Object object = wmiResult.getValue(t, n);
        if (object == null) {
            return 0;
        }
        if (wmiResult.getVtType(t) == 3) {
            return (Integer)object;
        }
        throw new ClassCastException(String.format(CLASS_CAST_MSG, t.name(), "32-bit integer", wmiResult.getCIMType(t), wmiResult.getVtType(t)));
    }

    public static <T extends Enum<T>> float getFloat(WbemcliUtil.WmiResult<T> wmiResult, T t, int n) {
        Object object = wmiResult.getValue(t, n);
        if (object == null) {
            return 0.0f;
        }
        if (wmiResult.getCIMType(t) == 4 && wmiResult.getVtType(t) == 4) {
            return ((Float)object).floatValue();
        }
        throw new ClassCastException(String.format(CLASS_CAST_MSG, t.name(), "Float", wmiResult.getCIMType(t), wmiResult.getVtType(t)));
    }
}

