/*
 * Decompiled with CFR 0.152.
 */
package de.jcm.discordgamesdk.impl.channel;

import de.jcm.discordgamesdk.impl.channel.DiscordChannel;
import de.jcm.discordgamesdk.impl.channel.NoSuchInstanceException;
import java.io.File;
import java.io.IOException;
import java.net.UnixDomainSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.IntStream;

public class UnixDiscordChannel
implements DiscordChannel {
    private final SocketChannel channel;

    private static String[] getSockets() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(System.getenv("XDG_RUNTIME_DIR"));
        arrayList.add(System.getenv("TMPDIR"));
        arrayList.add(System.getenv("TMP"));
        arrayList.add(System.getenv("TEMP"));
        arrayList.removeIf(Objects::isNull);
        arrayList.removeIf(string -> !new File((String)string).exists());
        List<String> list = arrayList.stream().map(string -> string + "/app/com.discordapp.Discord").toList();
        List<String> list2 = arrayList.stream().map(string -> string + "/snap.discord").toList();
        List list3 = arrayList.stream().flatMap(string2 -> Arrays.stream(Objects.requireNonNull(new File((String)string2).listFiles((file, string) -> string.startsWith("snap.discord_")))).map(File::getAbsolutePath)).toList();
        arrayList.addAll(list);
        arrayList.addAll(list2);
        arrayList.addAll(list3);
        arrayList.removeIf(Objects::isNull);
        arrayList.removeIf(string -> !new File((String)string).exists());
        return (String[])arrayList.stream().flatMap(string2 -> IntStream.iterate(0, n -> n + 1).mapToObj(n -> string2 + "/discord-ipc-" + n).takeWhile(string -> new File((String)string).exists())).toArray(String[]::new);
    }

    public UnixDiscordChannel() throws IOException {
        String string = System.getenv("DISCORD_IPC_PATH");
        if (string == null) {
            String string2 = System.getenv("DISCORD_INSTANCE_ID");
            int n = 0;
            if (string2 != null) {
                n = Integer.parseInt(string2);
            }
            String[] stringArray = UnixDiscordChannel.getSockets();
            if (n < 0 || n >= stringArray.length) {
                throw new NoSuchInstanceException(n);
            }
            string = stringArray[n];
        }
        this.channel = SocketChannel.open(UnixDomainSocketAddress.of(string));
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }

    @Override
    public void configureBlocking(boolean bl) throws IOException {
        this.channel.configureBlocking(bl);
    }

    @Override
    public int read(ByteBuffer byteBuffer) throws IOException {
        return this.channel.read(byteBuffer);
    }

    @Override
    public long read(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
        return this.channel.read(byteBufferArray, n, n2);
    }

    @Override
    public int write(ByteBuffer byteBuffer) throws IOException {
        return this.channel.write(byteBuffer);
    }
}

