/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.utils.launch;

import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.module.Configuration;
import java.lang.module.ModuleFinder;
import java.lang.module.ModuleReference;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import pro.gravit.utils.helper.HackHelper;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.JVMHelper;
import pro.gravit.utils.helper.LogHelper;
import pro.gravit.utils.launch.ClassLoaderControl;
import pro.gravit.utils.launch.ClassLoaderControl$ClassTransformer;
import pro.gravit.utils.launch.Launch;
import pro.gravit.utils.launch.LaunchOptions;
import pro.gravit.utils.launch.ModuleHacks;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class ModuleLaunch
implements Launch {
    private ModuleClassLoader moduleClassLoader;
    private Configuration configuration;
    private ModuleLayer.Controller controller;
    private ModuleFinder moduleFinder;
    private ModuleLayer layer;
    private MethodHandles.Lookup hackLookup;
    private boolean disablePackageDelegateSupport;

    @Override
    public ClassLoaderControl init(List<Path> list, String string2, LaunchOptions launchOptions) {
        this.disablePackageDelegateSupport = launchOptions.disablePackageDelegateSupport;
        this.moduleClassLoader = new ModuleClassLoader((URL[])list.stream().map(path -> {
            try {
                return path.toUri().toURL();
            }
            catch (MalformedURLException malformedURLException) {
                throw new RuntimeException(malformedURLException);
            }
        }).toArray(URL[]::new), ClassLoader.getPlatformClassLoader());
        this.moduleClassLoader.nativePath = string2;
        if (launchOptions.enableHacks) {
            this.hackLookup = HackHelper.createHackLookup(ModuleLaunch.class);
        }
        if (launchOptions.moduleConf != null) {
            Module module;
            Module module2;
            String string3;
            Object object;
            Object object2;
            this.moduleFinder = ModuleFinder.of((Path[])launchOptions.moduleConf.modulePath.stream().map(string -> Paths.get(string, new String[0])).map(Path::toAbsolutePath).toArray(Path[]::new));
            ModuleLayer moduleLayer = ModuleLayer.boot();
            if (launchOptions.moduleConf.modules.contains("ALL-MODULE-PATH")) {
                Map.Entry<String, String> entry;
                Iterator<Map.Entry<String, String>> iterator = this.moduleFinder.findAll();
                if (LogHelper.isDevEnabled()) {
                    entry = iterator.iterator();
                    while (entry.hasNext()) {
                        object2 = entry.next();
                        LogHelper.dev("Found module %s in %s", ((ModuleReference)object2).descriptor().name(), ((ModuleReference)object2).location().map(URI::toString).orElse("unknown"));
                    }
                    LogHelper.dev("Found %d modules", iterator.size());
                }
                entry = iterator.iterator();
                while (entry.hasNext()) {
                    object2 = entry.next();
                    launchOptions.moduleConf.modules.add(((ModuleReference)object2).descriptor().name());
                }
                launchOptions.moduleConf.modules.remove("ALL-MODULE-PATH");
            }
            this.configuration = moduleLayer.configuration().resolveAndBind(this.moduleFinder, ModuleFinder.of(new Path[0]), launchOptions.moduleConf.modules);
            this.controller = ModuleLayer.defineModulesWithOneLoader(this.configuration, List.of(moduleLayer), this.moduleClassLoader);
            this.layer = this.controller.layer();
            for (Map.Entry<String, String> entry : launchOptions.moduleConf.exports.entrySet()) {
                object2 = ((String)entry.getKey()).split("/");
                object = object2[0];
                string3 = object2[1];
                LogHelper.dev("Export module: %s package: %s to %s", object, string3, entry.getValue());
                module2 = this.layer.findModule(object2[0]).orElse(null);
                if (module2 == null) {
                    throw new RuntimeException(String.format("Module %s not found", object));
                }
                module = this.layer.findModule(entry.getValue()).orElse(null);
                if (module == null) {
                    throw new RuntimeException(String.format("Module %s not found", entry.getValue()));
                }
                if (launchOptions.enableHacks && module2.getLayer() != this.layer) {
                    ModuleHacks.createController(this.hackLookup, module2.getLayer()).addExports(module2, string3, module);
                    continue;
                }
                this.controller.addExports(module2, string3, module);
            }
            for (Map.Entry<String, String> entry : launchOptions.moduleConf.opens.entrySet()) {
                object2 = entry.getKey().split("/");
                object = object2[0];
                string3 = object2[1];
                LogHelper.dev("Open module: %s package: %s to %s", object, string3, entry.getValue());
                module2 = this.layer.findModule(object2[0]).orElse(null);
                if (module2 == null) {
                    throw new RuntimeException(String.format("Module %s not found", object));
                }
                module = this.layer.findModule(entry.getValue()).orElse(null);
                if (module == null) {
                    throw new RuntimeException(String.format("Module %s not found", entry.getValue()));
                }
                if (launchOptions.enableHacks && module2.getLayer() != this.layer) {
                    ModuleHacks.createController(this.hackLookup, module2.getLayer()).addOpens(module2, string3, module);
                    continue;
                }
                this.controller.addOpens(module2, string3, module);
            }
            for (Map.Entry<String, String> entry : launchOptions.moduleConf.reads.entrySet()) {
                LogHelper.dev("Read module %s to %s", entry.getKey(), entry.getValue());
                object2 = this.layer.findModule(entry.getKey()).orElse(null);
                if (object2 == null) {
                    throw new RuntimeException(String.format("Module %s not found", entry.getKey()));
                }
                object = this.layer.findModule(entry.getValue()).orElse(null);
                if (object == null) {
                    throw new RuntimeException(String.format("Module %s not found", entry.getValue()));
                }
                if (launchOptions.enableHacks && ((Module)object2).getLayer() != this.layer) {
                    ModuleHacks.createController(this.hackLookup, ((Module)object2).getLayer()).addReads((Module)object2, (Module)object);
                    continue;
                }
                this.controller.addReads((Module)object2, (Module)object);
            }
            this.moduleClassLoader.initializeWithLayer(this.layer);
        }
        return this.moduleClassLoader.makeControl();
    }

    @Override
    public void launch(String string, String string2, Collection<String> collection) throws Throwable {
        Thread.currentThread().setContextClassLoader(this.moduleClassLoader);
        if (string2 == null) {
            Class<?> clazz = Class.forName(string, true, this.moduleClassLoader);
            MethodHandle methodHandle = MethodHandles.lookup().findStatic(clazz, "main", MethodType.methodType(Void.TYPE, String[].class)).asFixedArity();
            JVMHelper.fullGC();
            methodHandle.asFixedArity().invokeWithArguments(new Object[]{collection.toArray(new String[0])});
            return;
        }
        Module module = this.layer.findModule(string2).orElseThrow();
        Module module2 = ModuleLaunch.class.getClassLoader().getUnnamedModule();
        if (module2 != null) {
            this.controller.addOpens(module, ModuleLaunch.getPackageFromClass(string), module2);
        }
        ClassLoader classLoader = module.getClassLoader();
        Class<?> clazz = Class.forName(string, true, classLoader);
        MethodHandle methodHandle = MethodHandles.lookup().findStatic(clazz, "main", MethodType.methodType(Void.TYPE, String[].class));
        methodHandle.asFixedArity().invokeWithArguments(new Object[]{collection.toArray(new String[0])});
    }

    private static String getPackageFromClass(String string) {
        int n = string.lastIndexOf(".");
        if (n >= 0) {
            return string.substring(0, n);
        }
        return string;
    }

    private class ModuleClassLoader
    extends URLClassLoader {
        private final ClassLoader SYSTEM_CLASS_LOADER;
        private final List<ClassLoaderControl$ClassTransformer> transformers;
        private final Map<String, Class<?>> classMap;
        private final Map<String, Module> packageToModule;
        private String nativePath;
        private final List<String> packages;

        public ModuleClassLoader(URL[] uRLArray, ClassLoader classLoader) {
            super("LAUNCHER", uRLArray, classLoader);
            this.SYSTEM_CLASS_LOADER = ClassLoader.getSystemClassLoader();
            this.transformers = new ArrayList<ClassLoaderControl$ClassTransformer>();
            this.classMap = new ConcurrentHashMap();
            this.packageToModule = new HashMap<String, Module>();
            this.packages = new ArrayList<String>();
            this.packages.add("pro.gravit.launcher.");
            this.packages.add("pro.gravit.utils.");
        }

        private void initializeWithLayer(ModuleLayer moduleLayer) {
            for (Module module : moduleLayer.modules()) {
                for (String string : module.getPackages()) {
                    this.packageToModule.put(string, module);
                }
            }
        }

        @Override
        protected Class<?> loadClass(String string, boolean bl) throws ClassNotFoundException {
            if (string != null && !ModuleLaunch.this.disablePackageDelegateSupport) {
                for (String string2 : this.packages) {
                    if (!string.startsWith(string2)) continue;
                    return this.SYSTEM_CLASS_LOADER.loadClass(string);
                }
            }
            return super.loadClass(string, bl);
        }

        @Override
        protected Class<?> findClass(String string) throws ClassNotFoundException {
            Class<?> clazz = this.findClass(null, string);
            if (clazz == null) {
                throw new ClassNotFoundException(string);
            }
            return clazz;
        }

        @Override
        protected Class<?> findClass(String string, String string2) {
            String string3;
            Object object;
            Class<?> clazz = this.classMap.get(string2);
            if (clazz != null) {
                return clazz;
            }
            if (string2 != null && !this.transformers.isEmpty()) {
                Object object2;
                boolean bl = false;
                object = this.transformers.iterator();
                while (object.hasNext()) {
                    object2 = object.next();
                    if (!object2.filter(string, string2)) continue;
                    bl = true;
                    break;
                }
                if (bl) {
                    object = string2.replace(".", "/").concat(".class");
                    try {
                        object2 = this.getResourceAsStream((String)object);
                        try {
                            byte[] byArray = IOHelper.read((InputStream)object2);
                            for (ClassLoaderControl$ClassTransformer classLoaderControl$ClassTransformer : this.transformers) {
                                byArray = classLoaderControl$ClassTransformer.transform(string, string2, null, byArray);
                            }
                            clazz = this.defineClass(string2, byArray, 0, byArray.length);
                        }
                        finally {
                            if (object2 != null) {
                                ((InputStream)object2).close();
                            }
                        }
                    }
                    catch (IOException iOException) {
                        return null;
                    }
                }
            }
            if (clazz == null && ModuleLaunch.this.layer != null && string2 != null && (object = this.packageToModule.get(string3 = ModuleLaunch.getPackageFromClass(string2))) != null) {
                try {
                    clazz = ((Module)object).getClassLoader().loadClass(string2);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    return null;
                }
            }
            if (clazz == null) {
                try {
                    clazz = super.findClass(string2);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    return null;
                }
            }
            if (clazz != null) {
                this.classMap.put(string2, clazz);
                return clazz;
            }
            return null;
        }

        @Override
        public String findLibrary(String string) {
            return this.nativePath.concat(IOHelper.PLATFORM_SEPARATOR).concat(JVMHelper.NATIVE_PREFIX).concat(string).concat(JVMHelper.NATIVE_EXTENSION);
        }

        public void addAllowedPackage(String string) {
            this.packages.add(string);
        }

        private ModuleClassLoaderControl makeControl() {
            return new ModuleClassLoaderControl();
        }

        private class ModuleClassLoaderControl
        implements ClassLoaderControl {
            private ModuleClassLoaderControl() {
            }

            @Override
            public void addLauncherPackage(String string) {
                ModuleClassLoader.this.addAllowedPackage(string);
            }

            @Override
            public void addTransformer(ClassLoaderControl$ClassTransformer classTransformer) {
                ModuleClassLoader.this.transformers.add(classTransformer);
            }

            @Override
            public void addURL(URL uRL) {
                ModuleClassLoader.this.addURL(uRL);
            }

            @Override
            public void addJar(Path path) {
                try {
                    ModuleClassLoader.this.addURL(path.toUri().toURL());
                }
                catch (MalformedURLException malformedURLException) {
                    throw new RuntimeException(malformedURLException);
                }
            }

            @Override
            public URL[] getURLs() {
                return ModuleClassLoader.this.getURLs();
            }

            @Override
            public Class<?> getClass(String string) throws ClassNotFoundException {
                return Class.forName(string, false, ModuleClassLoader.this);
            }

            @Override
            public ClassLoader getClassLoader() {
                return ModuleClassLoader.this;
            }

            @Override
            public Object getJava9ModuleController() {
                return ModuleLaunch.this.controller;
            }

            @Override
            public MethodHandles.Lookup getHackLookup() {
                return ModuleLaunch.this.hackLookup;
            }
        }
    }
}

