/*
 * Decompiled with CFR 0.152.
 */
package de.jcm.discordgamesdk.image;

import de.jcm.discordgamesdk.image.ImageType;
import java.util.Objects;

public class ImageHandle {
    private ImageType type;
    private long id;
    private int size;

    public ImageHandle(ImageType imageType, long l, int n) {
        this.type = Objects.requireNonNull(imageType);
        this.id = l;
        if (n < 16) {
            throw new IllegalArgumentException("size is smaller than 16: " + n);
        }
        if (n > 256) {
            throw new IllegalArgumentException("size is greater than 2048: " + n);
        }
        if ((n & n - 1) != 0) {
            throw new IllegalArgumentException("size is not a power of 2: " + n);
        }
        this.size = n;
    }

    ImageHandle(int n, long l, int n2) {
        this(ImageType.values()[n], l, n2);
    }

    public ImageType getType() {
        return this.type;
    }

    public void setType(ImageType imageType) {
        this.type = Objects.requireNonNull(imageType);
    }

    public long getId() {
        return this.id;
    }

    public void setId(long l) {
        this.id = l;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int n) {
        if ((n & n - 1) != 0) {
            throw new IllegalArgumentException("size is not a power of 2: " + n);
        }
        this.size = n;
    }

    public String toString() {
        return "ImageHandle{type=" + this.type + ", id=" + this.id + ", size=" + this.size + "}";
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ImageHandle imageHandle = (ImageHandle)object;
        return this.id == imageHandle.id && this.size == imageHandle.size && this.type == imageHandle.type;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.id, this.size});
    }
}

