/*
 * Decompiled with CFR 0.152.
 */
package de.jcm.discordgamesdk;

import de.jcm.discordgamesdk.Core;
import de.jcm.discordgamesdk.Result;
import de.jcm.discordgamesdk.impl.Command;
import de.jcm.discordgamesdk.impl.commands.SetUserVoiceSettings;
import de.jcm.discordgamesdk.impl.commands.SetVoiceSettings2;
import de.jcm.discordgamesdk.voice.VoiceInputMode;
import java.util.function.Consumer;

public class VoiceManager {
    private final Core.CorePrivate core;

    VoiceManager(Core.CorePrivate corePrivate) {
        this.core = corePrivate;
    }

    public VoiceInputMode getInputMode() {
        return this.core.voiceData.getInputMode();
    }

    public void setInputMode(VoiceInputMode voiceInputMode, Consumer<Result> consumer) {
        this.core.sendCommand(Command.Type.SET_VOICE_SETTINGS_2, new SetVoiceSettings2.InputMode(voiceInputMode), command -> consumer.accept(this.core.checkError((Command)command)));
        this.core.voiceData.input_mode = voiceInputMode;
    }

    public void setInputMode(VoiceInputMode voiceInputMode) {
        this.setInputMode(voiceInputMode, Core.DEFAULT_CALLBACK);
    }

    public boolean isSelfMute() {
        return this.core.voiceData.isSelfMute();
    }

    public void setSelfMute(boolean bl) {
        this.core.sendCommand(Command.Type.SET_VOICE_SETTINGS_2, new SetVoiceSettings2.SelfMute(bl), command -> Core.DEFAULT_CALLBACK.accept(this.core.checkError((Command)command)));
        this.core.voiceData.self_mute = bl;
    }

    public boolean isSelfDeaf() {
        return this.core.voiceData.isSelfDeaf();
    }

    public void setSelfDeaf(boolean bl) {
        this.core.sendCommand(Command.Type.SET_VOICE_SETTINGS_2, new SetVoiceSettings2.SelfDeaf(bl), command -> Core.DEFAULT_CALLBACK.accept(this.core.checkError((Command)command)));
        this.core.voiceData.self_deaf = bl;
    }

    public boolean isLocalMute(long l) {
        return this.core.voiceData.getLocalMutes().contains(Long.toString(l));
    }

    public void setLocalMute(long l, boolean bl) {
        String string = Long.toString(l);
        this.core.sendCommand(Command.Type.SET_USER_VOICE_SETTINGS_2, new SetUserVoiceSettings.Mute(string, bl), command -> Core.DEFAULT_CALLBACK.accept(this.core.checkError((Command)command)));
        boolean bl2 = this.core.voiceData.local_mutes.contains(string);
        if (bl2 && !bl) {
            this.core.voiceData.local_mutes.remove(string);
        } else if (!bl2 && bl) {
            this.core.voiceData.local_mutes.add(string);
        }
    }

    public int getLocalVolume(long l) {
        return this.core.voiceData.getLocalVolumes().getOrDefault(Long.toString(l), 100);
    }

    public void setLocalVolume(long l, int n) {
        if (n < 0 || n > 200) {
            throw new IllegalArgumentException("volume out of range: " + n);
        }
        String string = Long.toString(l);
        this.core.sendCommand(Command.Type.SET_USER_VOICE_SETTINGS_2, new SetUserVoiceSettings.Volume(string, n), command -> Core.DEFAULT_CALLBACK.accept(this.core.checkError((Command)command)));
        this.core.voiceData.getLocalVolumes().put(string, n);
    }
}

