/*
 * Decompiled with CFR 0.152.
 */
package de.jcm.discordgamesdk;

import de.jcm.discordgamesdk.Core;
import de.jcm.discordgamesdk.Result;
import de.jcm.discordgamesdk.activity.ActivityActionType;
import de.jcm.discordgamesdk.impl.Command;
import de.jcm.discordgamesdk.impl.commands.OpenOverlayActivityInvite;
import de.jcm.discordgamesdk.impl.commands.OpenOverlayGuildInvite;
import de.jcm.discordgamesdk.impl.commands.OpenOverlayVoiceSettings;
import de.jcm.discordgamesdk.impl.commands.SetOverlayLocked;
import java.util.function.Consumer;

public class OverlayManager {
    private final Core.CorePrivate core;

    OverlayManager(Core.CorePrivate corePrivate) {
        this.core = corePrivate;
    }

    public boolean isEnabled() {
        return this.core.overlayData.isEnabled();
    }

    public boolean isLocked() {
        return this.core.overlayData.isLocked();
    }

    public void setLocked(boolean bl) {
        this.setLocked(bl, Core.DEFAULT_CALLBACK);
    }

    public void setLocked(boolean bl, Consumer<Result> consumer) {
        this.core.sendCommand(Command.Type.SET_OVERLAY_LOCKED, new SetOverlayLocked.Args(bl, this.core.pid), command -> consumer.accept(this.core.checkError((Command)command)));
    }

    public void openActivityInvite(ActivityActionType activityActionType) {
        this.openActivityInvite(activityActionType, Core.DEFAULT_CALLBACK);
    }

    public void openActivityInvite(ActivityActionType activityActionType, Consumer<Result> consumer) {
        this.core.sendCommand(Command.Type.OPEN_OVERLAY_ACTIVITY_INVITE, new OpenOverlayActivityInvite.Args(activityActionType.nativeValue(), this.core.pid), command -> consumer.accept(this.core.checkError((Command)command)));
    }

    public void openGuildInvite(String string) {
        this.openGuildInvite(string, Core.DEFAULT_CALLBACK);
    }

    public void openGuildInvite(String string, Consumer<Result> consumer) {
        this.core.sendCommandNoResponse(Command.Type.OPEN_OVERLAY_GUILD_INVITE, new OpenOverlayGuildInvite.Args(string, this.core.pid), command -> consumer.accept(this.core.checkError((Command)command)));
    }

    public void openVoiceSettings() {
        this.openVoiceSettings(Core.DEFAULT_CALLBACK);
    }

    public void openVoiceSettings(Consumer<Result> consumer) {
        this.core.sendCommandNoResponse(Command.Type.OPEN_OVERLAY_VOICE_SETTINGS, new OpenOverlayVoiceSettings.Args(this.core.pid), command -> consumer.accept(this.core.checkError((Command)command)));
    }
}

