/*
 * Decompiled with CFR 0.152.
 */
package de.jcm.discordgamesdk;

import de.jcm.discordgamesdk.Core;
import de.jcm.discordgamesdk.GameSDKException;
import de.jcm.discordgamesdk.LogLevel;
import de.jcm.discordgamesdk.Result;
import de.jcm.discordgamesdk.image.ImageDimensions;
import de.jcm.discordgamesdk.image.ImageHandle;
import de.jcm.discordgamesdk.impl.Command;
import de.jcm.discordgamesdk.impl.commands.GetImage;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import javax.imageio.ImageIO;

public class ImageManager {
    private final Core.CorePrivate core;
    private final Map<ImageHandle, BufferedImage> imageCache = new HashMap<ImageHandle, BufferedImage>();

    ImageManager(Core.CorePrivate corePrivate) {
        this.core = corePrivate;
    }

    public void fetch(ImageHandle imageHandle, boolean bl, BiConsumer<Result, ImageHandle> biConsumer) {
        if (!bl && this.imageCache.containsKey(imageHandle)) {
            biConsumer.accept(Result.OK, imageHandle);
        } else {
            this.core.sendCommand(Command.Type.GET_IMAGE, new GetImage.Args(imageHandle), command -> {
                Result result = this.core.checkError((Command)command);
                if (result != Result.OK) {
                    biConsumer.accept(result, null);
                    return;
                }
                try {
                    GetImage.Response response = this.core.getGson().fromJson(command.getData(), GetImage.Response.class);
                    byte[] byArray = response.getData();
                    BufferedImage bufferedImage = ImageIO.read(new ByteArrayInputStream(byArray));
                    this.imageCache.put(imageHandle, bufferedImage);
                    biConsumer.accept(result, imageHandle);
                }
                catch (IOException iOException) {
                    this.core.log(LogLevel.ERROR, iOException.toString());
                    biConsumer.accept(Result.INTERNAL_ERROR, imageHandle);
                }
            });
        }
    }

    public ImageDimensions getDimensions(ImageHandle imageHandle) {
        if (!this.imageCache.containsKey(imageHandle)) {
            throw new GameSDKException(Result.NOT_FETCHED);
        }
        BufferedImage bufferedImage = this.imageCache.get(imageHandle);
        return new ImageDimensions(bufferedImage.getWidth(), bufferedImage.getHeight());
    }

    public byte[] getData(ImageHandle imageHandle, ImageDimensions imageDimensions) {
        return this.getData(imageHandle, imageDimensions.getWidth() * imageDimensions.getHeight() * 4);
    }

    public byte[] getData(ImageHandle imageHandle, int n) {
        if (!this.imageCache.containsKey(imageHandle)) {
            throw new GameSDKException(Result.NOT_FETCHED);
        }
        BufferedImage bufferedImage = this.imageCache.get(imageHandle);
        byte[] byArray = new byte[n];
        return (byte[])bufferedImage.getRaster().getDataElements(0, 0, byArray);
    }

    @Deprecated
    public BufferedImage getAsBufferedImage(ImageHandle imageHandle, ImageDimensions imageDimensions) {
        return this.getAsBufferedImage(imageHandle);
    }

    public BufferedImage getAsBufferedImage(ImageHandle imageHandle) {
        if (!this.imageCache.containsKey(imageHandle)) {
            throw new GameSDKException(Result.NOT_FETCHED);
        }
        return this.imageCache.get(imageHandle);
    }
}

