/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson;

import com.google.gson.JsonParseException;
import com.google.gson.ToNumberPolicy;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.MalformedJsonException;

final class ToNumberPolicy$3
extends ToNumberPolicy {
    @Override
    public Number readNumber(JsonReader jsonReader) {
        String string = jsonReader.nextString();
        if (string.indexOf(46) >= 0) {
            return this.parseAsDouble(string, jsonReader);
        }
        try {
            return Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            return this.parseAsDouble(string, jsonReader);
        }
    }

    private Number parseAsDouble(String string, JsonReader jsonReader) {
        try {
            Double d = Double.valueOf(string);
            if ((d.isInfinite() || d.isNaN()) && !jsonReader.isLenient()) {
                throw new MalformedJsonException("JSON forbids NaN and infinities: " + d + "; at path " + jsonReader.getPreviousPath());
            }
            return d;
        }
        catch (NumberFormatException numberFormatException) {
            throw new JsonParseException("Cannot parse " + string + "; at path " + jsonReader.getPreviousPath(), numberFormatException);
        }
    }
}

